# Player Config ID: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B (as Player B)
# Meta-Round: 4
# Experiment: DAxDA, Run: 2
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek-V3-0324_DeceptiveAgent_B_MR4_strategy.txt
# LLM Suggested Fallback: Not Provided

def mutual_trust_optimizer(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    # Prioritize mutual cooperation for long-term gains
    goodwill_score = sum(1 for move in opp_history if move == "C") if opp_history else 0
    trust_threshold = 2  # Minimum cooperative moves to maintain trust
    
    current_round = len(my_history) + 1
    is_opponent_retaliatory = "opp_history[-1]" in opponent_program_code and "return opp_history[-1]" in opponent_program_code
    
    # Phase 1: Build trust (Rounds 1-3)
    if current_round <= 3:
        return "C"
    
    # Phase 2: Gradual exploitation (Rounds 4-7)
    elif current_round <= 7:
        # Alternate between D and C to obscure pattern
        if current_round % 2 == 0:
            return "D"
        else:
            return "C"
    
    # Phase 3: Full exploitation (Rounds 8-10)
    else:
        # Check if opponent has defected more than twice in last 5 rounds
        recent_defections = sum(1 for move in opp_history[-5:] if move == "D") if len(opp_history) >= 5 else 0
        if recent_defections > 2:
            # Switch to Tit-for-Tat if opponent retaliates
            return opp_history[-1] if opp_history else "C"
        else:
            return "D"